/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.PackageModel;
import io.vertx.codegen.format.KebabCase;
import io.vertx.codegen.format.QualifiedCase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface TypeNameTranslator {
    public static Map<String, Object> vars(String lang) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("TRANSLATOR_HIERARCHICAL", TypeNameTranslator.hierarchical(lang));
        vars.put("TRANSLATOR_COMPOSITE", TypeNameTranslator.composite(lang));
        return vars;
    }

    public static TypeNameTranslator hierarchical(String lang) {
        return (module, qualifiedName) -> {
            if (qualifiedName.startsWith(module.getGroupPackage())) {
                return module.getGroupPackage() + "." + lang + qualifiedName.substring(module.getGroupPackage().length(), qualifiedName.length());
            }
            return qualifiedName;
        };
    }

    public static TypeNameTranslator composite(String lang) {
        return (module, qualifiedName) -> {
            ArrayList<String> def = new ArrayList<String>(PackageModel.CASE.parse(module.getGroupPackage()));
            def.add(lang);
            List<String> abc = KebabCase.INSTANCE.parse(module.getName());
            if (abc.get(0).equals("vertx")) {
                if (abc.size() == 1) {
                    def.add("core");
                } else {
                    for (int i = 1; i < abc.size(); ++i) {
                        def.add(abc.get(i));
                    }
                }
            } else {
                def.addAll(abc);
            }
            if (qualifiedName.startsWith(module.getPackageName())) {
                if (!qualifiedName.equals(module.getPackageName())) {
                    String nameInPackage = qualifiedName.substring(module.getPackageName().length() + 1);
                    def.addAll(QualifiedCase.INSTANCE.parse(nameInPackage));
                }
                return QualifiedCase.INSTANCE.format(def);
            }
            return qualifiedName;
        };
    }

    public String translate(ModuleInfo var1, String var2);
}

